<?php
require_once 'config.php';

// Set content type
header('Content-Type: application/json');

// Only allow POST requests
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    jsonResponse(false, 'Method not allowed', null, 405);
}

// Get JSON input
$jsonInput = file_get_contents('php://input');
$data = json_decode($jsonInput, true);

if (!$data) {
    jsonResponse(false, 'Invalid JSON data', null, 400);
}

// Get session ID
$sessionId = sanitizeInput($data['session_id'] ?? '');

if (empty($sessionId)) {
    jsonResponse(false, 'Session ID required', null, 400);
}

// Destroy session
try {
    destroySession($sessionId);
    jsonResponse(true, 'Logout successful');
    
} catch (Exception $e) {
    error_log('Logout error: ' . $e->getMessage());
    jsonResponse(false, 'Logout failed', null, 500);
}
?>